     // Ovladani jednotlivych bitu registru
#define setbit(reg, bit)      ((reg) |= (1U << (bit)))
#define clearbit(reg, bit)    ((reg) &= (~(1U << (bit))))
#define togglebit(reg, bit)   ((reg) ^= (1U << (bit)))
#define getbit(reg, bit)      (((reg) & (1U << (bit))) >> (bit))

void PIN_OUTPP_Initialize (GPIO_TypeDef *GPIO, unsigned char bit)  // Typ brany GPIO, ktery bit 
{    // Nastaveni vvodu GPIOx.bit na vstup push-pull, bez upnut k napjen nebo zemi
     GPIO->MODER   &= ~((3ul << 2*bit));         // Stav po nulovani (ruseni predchoziho stavu)
     GPIO->MODER   |=  ((1ul << 2*bit));         // Vystup
     GPIO->OTYPER  &= ~((1ul <<   bit));         // Push-Pull
     GPIO->OSPEEDR &= ~((3ul << 2*bit));         // Ruseni predchoziho stavu 
     GPIO->OSPEEDR |=  ((1ul << 2*bit));         // Medium speed
     GPIO->PUPDR   &= ~((3ul << 2*bit));
     return;
}

void PIN_IN_nn_Initialize (GPIO_TypeDef *GPIO, unsigned char bit) // Typ brany GPIO, ktery bit
{    // Nastaveni vvodu GPIOx.bit na vstup bez upnut k napjen nebo zemi     
     GPIO->MODER   &= ~(3ul << 2*bit);           // Vstup
     GPIO->OSPEEDR &= ~(3ul << 2*bit);           // Ruseni predchoziho stavu 
     GPIO->OSPEEDR |=  (1ul << 2*bit);           // Medium speed
     GPIO->PUPDR   &= ~(3ul << 2*bit);           // Bez upinacich odporu
     return;
}

void PIN_IN_Un_Initialize (GPIO_TypeDef *GPIO, unsigned char bit) // Typ brany GPIO, ktery bit
{    // Nastaveni vvodu GPIOx.bit na vstup bez upnut k napjen nebo zemi     
     GPIO->MODER   &= ~(3ul << 2*bit);           // Vstup
     GPIO->OSPEEDR &= ~(3ul << 2*bit);           // Ruseni predchoziho stavu 
     GPIO->OSPEEDR |=  (1ul << 2*bit);           // Medium speed
     GPIO->PUPDR   &= ~(3ul << 2*bit);           // Bez upinacich odporu
     GPIO->PUPDR   |=  (1ul << 2*bit);           // Pull UP
     return;
}

void PIN_ALT_Un_Initialize (GPIO_TypeDef *GPIO, unsigned char bit) // Typ brany GPIO, ktery bit
{    // Nastaveni vvodu GPIOx.bit na vstup bez upnut k napjen nebo zemi     
     GPIO->MODER   &= ~(3ul << 2*bit);           // Nastaven stavu po resetu 
     GPIO->MODER   |=  (2ul << 2*bit);           // Nastaven alternativn funkce 
     GPIO->OSPEEDR &= ~(3ul << 2*bit);           // Ruseni predchoziho stavu 
     GPIO->OSPEEDR |=  (1ul << 2*bit);           // Medium speed
     GPIO->PUPDR   &= ~(3ul << 2*bit);           // Bez upinacich odporu
     GPIO->PUPDR   |=  (1ul << 2*bit);           // Pull UP
     return;
}

void PIN_ALT_PP_Initialize (GPIO_TypeDef *GPIO, unsigned char bit) // Typ brany GPIO, ktery bit
{    // Nastaveni vvodu GPIOx.bit na vstup bez upnut k napjen nebo zemi     
     GPIO->MODER   &= ~(3ul << 2*bit);           // Nastaven stavu po resetu 
     GPIO->MODER   |=  (2ul << 2*bit);           // Nastaven alternativn funkce 
     GPIO->OTYPER  &= ~((1ul << bit));           // Push-Pull
     GPIO->OSPEEDR &= ~(3ul << 2*bit);           // Ruseni predchoziho stavu 
     GPIO->OSPEEDR |=  (1ul << 2*bit);           // Medium speed
     GPIO->PUPDR   &= ~(3ul << 2*bit);           // Bez upinacich odporu
     return;
}

void PIN_ANALOG_Initialize (GPIO_TypeDef *GPIO, unsigned char bit) // Typ brany GPIO, ktery bit
{    // Nastaveni vvodu GPIOx.bit na vstup bez upnut k napjen nebo zemi     
     GPIO->MODER   &= ~(3ul << 2*bit);           // Nastaven stavu po resetu 
     GPIO->MODER   |=  (3ul << 2*bit);           // Nastaven analogove funkce
     GPIO->OTYPER  |=  ((1ul << bit));           // Oteven kolektor
     GPIO->OSPEEDR &= ~(3ul << 2*bit);           // Ruseni predchoziho stavu 
     GPIO->OSPEEDR |=  (1ul << 2*bit);           // Medium speed
     GPIO->PUPDR   &= ~(3ul << 2*bit);           // Bez upinacich odporu
     return;
}

void CELA_BRANA_Initialize (GPIO_TypeDef *GPIO, unsigned int moder, unsigned int typer, 
	                          unsigned int speedr, unsigned int puder) 
{    // Nastaveni cele brany GPIOx     
     GPIO->MODER   = moder;                         // 
     GPIO->OTYPER  = typer;                         //  
     GPIO->OSPEEDR = speedr;                        // 
     GPIO->PUPDR   = puder;                         // 
     return;
}

unsigned int INPUT (GPIO_TypeDef *GPIO)                     // Typ brany GPIO, cteni brany 
{    return (GPIO->IDR);
}

void OUTPUT (GPIO_TypeDef *GPIO, unsigned int hodnota) // Typ brany GPIO, zapis do brany 
{    GPIO->ODR = hodnota;
}
